define([
    'backbone',
    'marionette',
    'modules/notification-preferences/notification-preferences-module',
    'modules/form/section-view',
    'text!modules/form/section-with-heading.html',
    'json!modules/notification-preferences/notification-form.json',
],
function(
    Backbone,
    Marionette,
    module,
    SectionView,
    template,
    metadata
) {
    'use strict';

    return SectionView.extend({
        template: template,

        initialize: function(options) {
            var sectionName = 'notification-phone-inputs';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata, options);

            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
            this.validator = options.validator;
            this.errorSection = options.errorSection;
        },

        updateQuestionValuesAndRender: function(contactPreferences) {
            if (!this.isDestroyed()) {
                this.collection.each(function(question) {
                    question.set('value', contactPreferences.get(question.get('id')));
                }, this);
                this.render();

                this.initChildren();
            }
        },

        onRender: function() {
            this.initChildren();
            this.listenTo(module.notificationPreferences, 'sync', this.updateQuestionValuesAndRender);

            this.addFormValidationRules();
        },

        addFormValidationRules: function() {
            this.$el.find('#phoneNumber').rules('add', {
                phoneUS: true,
                messages: {phoneUS: 'Please enter a valid US Phone number.'},
            });
        },
    });
});
